/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.sweenus.simplyswords.power.GemPower;
import net.sweenus.simplyswords.registry.GemPowerRegistry;
import net.sweenus.simplyswords.util.Styles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record GemPowerComponent(boolean hasRunicPower, boolean hasNetherPower, class_6880<GemPower> runicPower, class_6880<GemPower> netherPower) {
    public static final Codec<GemPowerComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("has_runic_power").forGetter(GemPowerComponent::hasRunicPower), (App)Codec.BOOL.fieldOf("has_nether_power").forGetter(GemPowerComponent::hasNetherPower), (App)new GemPower.GemPowerCodec().fieldOf("runic_power").forGetter(GemPowerComponent::runicPower), (App)new GemPower.GemPowerCodec().fieldOf("nether_power").forGetter(GemPowerComponent::netherPower)).apply((Applicative)instance, GemPowerComponent::new));
    public static final class_9139<class_9129, GemPowerComponent> PACKET_CODEC = class_9139.method_56905((class_9139)class_9135.field_48547, GemPowerComponent::hasRunicPower, (class_9139)class_9135.field_48547, GemPowerComponent::hasNetherPower, (class_9139)class_9135.method_56383((class_5321)GemPowerRegistry.REGISTRY.key()), GemPowerComponent::runicPower, (class_9139)class_9135.method_56383((class_5321)GemPowerRegistry.REGISTRY.key()), GemPowerComponent::netherPower, GemPowerComponent::new);
    public static final GemPowerComponent DEFAULT = new GemPowerComponent(false, false, (class_6880<GemPower>)GemPowerRegistry.EMPTY, (class_6880<GemPower>)GemPowerRegistry.EMPTY);

    @Override
    public boolean equals(Object componentObject) {
        if (componentObject == null || this.getClass() != componentObject.getClass()) {
            return false;
        }
        GemPowerComponent gemPowerComponentObject = (GemPowerComponent)componentObject;
        return this == gemPowerComponentObject;
    }

    public static GemPowerComponent runic(@NotNull class_6880<GemPower> power) {
        return new GemPowerComponent(true, false, power, (class_6880<GemPower>)GemPowerRegistry.EMPTY);
    }

    public static GemPowerComponent nether(@NotNull class_6880<GemPower> power) {
        return new GemPowerComponent(false, true, (class_6880<GemPower>)GemPowerRegistry.EMPTY, power);
    }

    public static GemPowerComponent create(@Nullable class_6880<GemPower> runic, @Nullable class_6880<GemPower> nether) {
        return new GemPowerComponent(runic != null, nether != null, (class_6880<GemPower>)(runic != null ? runic : GemPowerRegistry.EMPTY), (class_6880<GemPower>)(nether != null ? nether : GemPowerRegistry.EMPTY));
    }

    public static GemPowerComponent createEmpty(boolean hasRunic, boolean hasNether) {
        return new GemPowerComponent(hasRunic, hasNether, (class_6880<GemPower>)GemPowerRegistry.EMPTY, (class_6880<GemPower>)GemPowerRegistry.EMPTY);
    }

    public GemPowerComponent fill(BiFunction<Boolean, class_6880<GemPower>, class_6880<GemPower>> runicFiller, BiFunction<Boolean, class_6880<GemPower>, class_6880<GemPower>> netherFiller) {
        return new GemPowerComponent(this.hasRunicPower, this.hasNetherPower, runicFiller.apply(this.hasRunicPower, this.runicPower), netherFiller.apply(this.hasNetherPower, this.netherPower));
    }

    public boolean canBeFilled() {
        return this.hasRunicPower || this.hasNetherPower;
    }

    public boolean isEmpty() {
        return ((GemPower)this.runicPower.comp_349()).isEmpty() && ((GemPower)this.netherPower.comp_349()).isEmpty();
    }

    public boolean hasPower(class_6880<GemPower> power) {
        if (this.isEmpty()) {
            return false;
        }
        return !((GemPower)this.runicPower.comp_349()).isEmpty() && power.method_40229() == this.runicPower.method_40229() || !((GemPower)this.netherPower.comp_349()).isEmpty() && power.method_40229() == this.netherPower.method_40229();
    }

    public boolean hasRunic(class_6880<GemPower> power) {
        return !((GemPower)this.runicPower.comp_349()).isEmpty() && power.method_40229().equals(this.runicPower.method_40229());
    }

    public boolean hasNether(class_6880<GemPower> power) {
        return !((GemPower)this.netherPower.comp_349()).isEmpty() && power.method_40229() == this.netherPower.method_40229();
    }

    public void postHit(class_1799 stack, class_1309 target, class_1309 attacker) {
        ((GemPower)this.runicPower.comp_349()).postHit(stack, target, attacker);
        ((GemPower)this.netherPower.comp_349()).postHit(stack, target, attacker);
    }

    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        class_1271<class_1799> result1 = ((GemPower)this.runicPower.comp_349()).use(world, user, hand, itemStack);
        class_1271<class_1799> result2 = ((GemPower)this.netherPower.comp_349()).use(world, user, hand, itemStack);
        if (result1.method_5467().compareTo((Enum)result2.method_5467()) < 0) {
            return result1;
        }
        return result2;
    }

    public void usageTick(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        ((GemPower)this.runicPower.comp_349()).usageTick(world, user, stack, remainingUseTicks);
        ((GemPower)this.netherPower.comp_349()).usageTick(world, user, stack, remainingUseTicks);
    }

    public void onStoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        ((GemPower)this.runicPower.comp_349()).onStoppedUsing(stack, world, user, remainingUseTicks);
        ((GemPower)this.netherPower.comp_349()).onStoppedUsing(stack, world, user, remainingUseTicks);
    }

    public int getMaxUseTime(class_1799 stack) {
        return Math.max(((GemPower)this.runicPower.comp_349()).getMaxUseTime(stack), ((GemPower)this.netherPower.comp_349()).getMaxUseTime(stack));
    }

    public void inventoryTick(class_1799 stack, class_1937 world, class_1309 user, int slot, boolean selected) {
        ((GemPower)this.runicPower.comp_349()).inventoryTick(stack, world, user, slot, selected);
        ((GemPower)this.netherPower.comp_349()).inventoryTick(stack, world, user, slot, selected);
    }

    public void appendTooltip(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        this.appendTooltip(itemStack, tooltipContext, tooltip, type, false);
    }

    public void appendTooltip(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type, boolean isRunic) {
        if (((GemPower)this.runicPower.comp_349()).isGreater()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.greater_runic_power").method_10862(Styles.RUNIC));
        }
        if (!((GemPower)this.runicPower.comp_349()).isEmpty()) {
            ((GemPower)this.runicPower.comp_349()).appendTooltip(itemStack, tooltipContext, tooltip, type, isRunic);
        } else if (!isRunic && this.hasRunicPower) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.empty_runic_slot").method_10862(Styles.RUNIC));
        }
        if (((GemPower)this.netherPower.comp_349()).isGreater()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.greater_nether_power").method_10862(Styles.NETHERFUSED));
        }
        if (!((GemPower)this.netherPower.comp_349()).isEmpty()) {
            ((GemPower)this.netherPower.comp_349()).appendTooltip(itemStack, tooltipContext, tooltip, type, isRunic);
        } else if (!isRunic && this.hasNetherPower) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.empty_nether_slot").method_10862(Styles.NETHERFUSED));
        }
    }
}

